#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<random>
using namespace std;
const int N = 4336; // number of demands
const int dim = 2; // demension 
double cost = 0; // total cost
double delta[11]; 
double pr[11]; // probability
const double eps = 1e-9; 
struct demand {
	double x[dim + 1];
	double c;
}D[N + 1];
vector<demand> Fset[10]; //Fset[i] stores all the facility which can be opened with cost in [2^{i-1}, 2^{i}), Fset[0] stores all the opened facility
default_random_engine e;
uniform_real_distribution<double> u(0,1); 

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

inline void open(demand &d, int level) {
	int pos = 0;
	for (int j = 1; j < Fset[level].size(); j++) 
		if (dist(d, Fset[level][j]) < dist(d, Fset[level][0])) 
			pos = j;
	Fset[0].push_back(Fset[level][pos]);
	cost += Fset[level][pos].c;
}

int main() {
	freopen("nonuniform.txt", "r", stdin);
	//freopen("lb.txt", "r", stdin);
	//freopen("timestamped_gps_coordinate.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		for (int j = 1; j <= dim; j++)
			scanf("%lf", &D[i].x[j]);
		scanf("%lf", &D[i].c);
		int w = 1;
		for (int j = 0; j < 10; j++) // change the open cost to the power of 2
			if (D[i].c >= w && D[i].c < 2 * w) {
				Fset[j + 1].push_back(D[i]);  
				break;
			}
	}
	for (int cnt = 1; cnt <= 10; cnt++) {
		Fset[0].clear();
		e.seed(time(0));
		for (int i = 1; i <= N; i++) {
			delta[0] = 1e9;
			for (int j = 0; j < Fset[0].size(); j++)
				delta[0] = min(delta[0], dist(Fset[0][j], D[i]));
			for (int j = 1; j < 10; j++) {    //get delta
				delta[j] = delta[j - 1];
				for (int k = 0; k < Fset[j].size(); k++)
					delta[j] = min(delta[j], dist(Fset[j][k], D[i]));
			}
			int w = 1;
			for (int j = 1; j < 10; j++) {
				pr[j] = (delta[j - 1] - delta[j]) / w; //compute probability
				w = w * 2;
			}
			double r = u(e);
			double sum = 0;
			bool flag = 0;
			for (int j = 9; j >= 1; j--) {
				sum = sum + pr[j];
				if (r <= sum) {
					open(D[i], j);
					flag = 1;
					cost += delta[j];
					break;
				} 
			}
			if (!flag) 
				cost += delta[0];
		//	printf("%lf\n", cost);
		}
	}
	printf("%lf\n", cost / 10);
	printf("%lu\n", Fset[0].size());
}